//+------------------------------------------------------------------+
//|                                         London new york open.mq4 |
//|                                        Copyright  2011, tigpips |
//|                                                tigpips@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, tigpips"
#property link      "tigpips@gmail.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Blue

extern int     GMTOffSet       = 1;
extern bool    DST             = true;
extern int		LondonOpenHour	 = 7;
extern int     LondonOpenMin   = 0;
extern int		NewYorkOpenHour = 12;
extern int     NewYorkOpenMin  = 0;
extern int     DotDistance     = 30;
extern bool    UseBarCount     = false;
extern int     BarCount        = 500;

double dLondonBuffer[];
double dNewYorkBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {

//---- drawing settings
   SetIndexArrow(0, 108);
   SetIndexArrow(1, 108);
//----  
   SetIndexStyle(0, DRAW_ARROW, STYLE_DOT,1);
   SetIndexBuffer(0, dLondonBuffer);
   SetIndexLabel(0,"London Open");
//----    
   SetIndexStyle(1,DRAW_ARROW,STYLE_DOT,1);
   SetIndexBuffer(1, dNewYorkBuffer);
   SetIndexLabel(1,"New York Open");

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int LondonOpenHour2;
   int NewYorkOpenHour2;
   int iBarsToCalc;
   
   if(DST == false)
   {
      LondonOpenHour2 = LondonOpenHour + GMTOffSet;
      NewYorkOpenHour2 = NewYorkOpenHour + GMTOffSet;
   }
   else
   {
      LondonOpenHour2 = LondonOpenHour + GMTOffSet + 1;
      NewYorkOpenHour2 = NewYorkOpenHour + GMTOffSet + 1;
   }
   
   if(UseBarCount == true)
   {
      iBarsToCalc = BarCount; 
   }
   else
   {
      iBarsToCalc = Bars - IndicatorCounted();
	}
	if (iBarsToCalc < Bars) iBarsToCalc++;
   
	for (int i=iBarsToCalc-1;i>=0;i--) 
     {   
      if(isMarketOpen(LondonOpenHour2, LondonOpenMin, Time[i])==true)
      {
         dLondonBuffer[i] = High[i] + (DotDistance * Point);
		}
		else
		{
			dLondonBuffer[i] = EMPTY_VALUE;
      }
      
      if(isMarketOpen(NewYorkOpenHour2, NewYorkOpenMin, Time[i])==true)
      {
         dNewYorkBuffer[i] = High[i] + (DotDistance * Point);
		}
		else
		{
			dNewYorkBuffer[i] = EMPTY_VALUE;
      }
   }
   return(0);
  }
//+------------------------------------------------------------------+

bool isMarketOpen(int iOpenHour, int iOpenMin, datetime timestamp) {

	int iBarHour = TimeHour(timestamp);
	int iBarMin = TimeMinute(timestamp);
	if (iBarHour == iOpenHour && iBarMin == iOpenMin)
	{
		return(true);
   }
   else
   {
	  return(false);
	}
}


